﻿Scriptname _JSW_G_HandlerQuestAliasScript extends ReferenceAlias  

Actor Property PlayerRef  Auto

GlobalVariable Property MasteryDelta  Auto
GlobalVariable Property SkillDelta  Auto
GlobalVariable Property ConsumeTomes  Auto

Book Property TomeFlames  Auto
Book Property TomeHealing  Auto

Spell Property MasterySpell  Auto

Form[] Property SpellTomes  Auto
Form[] Property Spells  Auto
string[] Property Skill  Auto
int[] Property Level  Auto
float[] Property Mastery  Auto

event OnInit()
{Ensure everything is sorted when loading starting for the first time}
	Debug.Notification("Initializing Grimoire...")
	
	Spell flames = TomeFlames.GetSpell()
	Spell healing = TomeHealing.GetSpell()
	
	; Ensure the vanilla starting spells are handled consistently
	if (SpellTomes.Find(TomeFlames) == -1 && PlayerRef.HasSpell(flames) && PlayerRef.GetItemCount(TomeFlames) == 0)
		Debug.Notification("Grimoire: Adding '" + TomeFlames.GetName() + "'")
		AddUnknownTome(TomeFlames, flames)
		PlayerRef.AddItem(TomeFlames, 1, true)
	endIf
	
	if (SpellTomes.Find(TomeHealing) == -1 && PlayerRef.HasSpell(healing) && PlayerRef.GetItemCount(TomeHealing) == 0)
		Debug.Notification("Grimoire: Adding '" + TomeHealing.GetName() + "'")
		AddUnknownTome(TomeHealing, healing)
		PlayerRef.AddItem(TomeHealing, 1, true)
	endIf
endEvent

event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
{Reject or accept equipping a spell based on mastery or the presence of a spell tome}
	if (akBaseObject as Spell)
		Spell equippedSpell = akBaseObject as Spell
		
		if (equippedSpell)
			int index = Spells.Find(equippedSpell)
			
			; Check for either mastery or the presence of a spell tome
			if (index != -1)
				if (Mastery[index] < 1.0 && PlayerRef.GetItemCount(SpellTomes[index]) == 0)
					Debug.MessageBox("A '" + SpellTomes[index].GetName() + "' grimoire is required to use " + equippedSpell.GetName())
					PlayerRef.UnequipSpell(equippedSpell, 0)
					PlayerRef.UnequipSpell(equippedSpell, 1)
				endIf
			endIf
		endif
	elseIf (akBaseObject as Book)
		Book tome = akBaseObject as Book
		Spell learnedSpell = tome.GetSpell()
		int index = SpellTomes.Find(tome)
		
		if (learnedSpell && index == -1)
			AddUnknownTome(tome, learnedSpell)
			
			if (!ConsumeTomes.GetValueInt() && PlayerRef.GetItemCount(tome) == 1)
				PlayerRef.AddItem(tome, 1, true)
			endIf
		endIf
	endIf
endEvent

event OnSpellCast(Form akSpell)
{Update mastery when casting a recognized spell}
	if (akSpell)
		int index = Spells.Find(akSpell)
		float lastMastery = Mastery[index]
		
		if (index != -1 && Mastery[index] <= 1.0)
			float delta = MasteryDelta.GetValue()
			int playerSkill = PlayerRef.GetActorValue(Skill[index]) as int
			int skillDiff = playerSkill - Level[index]
			
			if (skillDiff < 0)
				skillDiff = 0
			endIf
			
			skillDiff /= 25
			delta += (SkillDelta.Getvalue() * skillDiff)
			
			Mastery[index] = Mastery[index] + delta
			
			if (lastMastery <= 1.0 && Mastery[index] > 1.0)
				MasterySpell.Cast(PlayerRef)
				Debug.Notification(akSpell.GetName() + " has been mastered")
			endIf
		endIf
	endIf
endEvent

function AddUnknownTome(Book tome, Spell learnedSpell)
{Append the given tome and spell to the lists}
	if (SpellTomes.Find(tome) == -1)
		string spellSkill = learnedSpell.GetNthEffectMagicEffect(learnedSpell.GetCostliestEffectIndex()).GetAssociatedSkill()
		int spellLevel = learnedSpell.GetNthEffectMagicEffect(learnedSpell.GetCostliestEffectIndex()).GetSkillLevel()
		
		SpellTomes = Utility.ResizeFormArray(SpellTomes, SpellTomes.Length + 1, tome)
		Spells = Utility.ResizeFormArray(Spells, Spells.Length + 1, learnedSpell)
		Skill = Utility.ResizeStringArray(Skill, Skill.Length + 1, spellSkill)
		Level = Utility.ResizeIntArray(Level, Level.Length + 1, spellLevel)
		Mastery = Utility.ResizeFloatArray(Mastery, Mastery.Length + 1, 0.0)
	endIf
endFunction